package com.ht.bo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.faces.bean.ManagedBean;
import javax.faces.bean.RequestScoped;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpSession;

import com.ht.util.ConnectionUtil;
import com.ht.vo.Cart;
import com.ht.vo.Product;

@ManagedBean(name = "product")
@SessionScoped
public class ProductBean implements Serializable {

	private static final long serialVersionUID = 1L;
	public int itemCount = 0;
	private ArrayList<Product> orderList = null;

	public ProductBean() {
		super();
		// orderList = populateOrderList();
	}

	public ArrayList<Product> getOrderList() {

		return orderList;
	}

	public ArrayList<Product> populateOrderList() {

		KanglaEbookBO bo = new KanglaEbookBO();
		String category = ConnectionUtil
				.constructCategoryID(getCatalogCategory());
		List<Product> prodList = bo.findAllBooksBySubCatalog(category);
		return (ArrayList<Product>) prodList;
	}

	public void setOrderList(ArrayList<Product> orderList) {
		this.orderList = orderList;
	}

	private Cart cartBean;
	private String catalog;

	public String getCatalog() {
		return getCatalogCategory();
	}

	public void setCatalog(String catalog) {
		this.catalog = catalog;
	}

	public Cart getCartBean() {
		return cartBean;
	}

	public void setCartBean(Cart cartBean) {
		this.cartBean = cartBean;
	}

	private Cart getMyShoppingCart() {
		HttpSession session = (HttpSession) FacesContext.getCurrentInstance()
				.getExternalContext().getSession(false);
		System.out.println("Session:" + session.getAttribute("mycart"));
		return ((Cart) session.getAttribute("mycart"));
	}

	private String getCatalogCategory() {
		HttpSession session = (HttpSession) FacesContext.getCurrentInstance()
				.getExternalContext().getSession(false);
		return session.getAttribute("catalog").toString();
	}

	public int getItemCount() {
		// int count = getMyShoppingCart().getProdList().size();
		return totalCalcItems();
	}

	public void setItemCount(int itemCount) {
		this.itemCount = itemCount;
	}

	private int totalCalcItems() {
		int items = 0;
		for (Product order : getMyShoppingCart().getProdList()) {
			items += order.getQty();
		}
		return items;
	}

	public String saveAction() {

		// get all existing value but set "editable" to false
		HttpSession session = (HttpSession) FacesContext.getCurrentInstance()
				.getExternalContext().getSession(false);
		ArrayList<Product> prodList = (ArrayList<Product>) session.getAttribute("prodList");
		for (Product order : prodList) {
			if (order.getQty() > 0) {
				System.out.println(order.getProductID() + "-- "
						+ order.getQty() + "------>" + getCartBean());
				getMyShoppingCart().getProdList().add(order);
			}
			order.setEditable(false);
		}

		//setCartBean(getMyShoppingCart());
		System.out.println("I saved" + getMyShoppingCart().getProdList());
		// return to current page
		return null;

	}

	public String showAction() {
		ArrayList<Product> prodList = (ArrayList<Product>) getMyShoppingCart()
				.getProdList();
		for (Product order : prodList) {
			order.setEditable(false);
		}
		return "cart";
	}

	public String editAction(Product order) {

		order.setEditable(true);
		return null;
	}

}